<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use Illuminate\Support\Facades\View;

class AuthController extends Controller
{
    public function showLoginForm()
    {
       /*  return '<form method="POST" action="' . route('login') . '">
                    ' . csrf_field() . '
                    <input type="text" name="dni" placeholder="Ingrese su DNI" required>
                    <button type="submit">Ingresar</button>
                </form>'; */
                return view('logindni');
    }

    public function login(Request $request)
    {
        $user = User::where('dni', $request->dni)->first();

        if ($user) {
            Auth::login($user);
            return redirect()->route('dashboard');
        }

        return 'DNI no encontrado';
    }

    public function dashboard()
    {
        if (!Auth::check()) {
            return redirect()->route('login.form');
        }

     /*    return 'Bienvenido, ' . Auth::user()->dni . ' | <a href="' . route('logout') . '">Cerrar sesión</a>'; */
     return view('dash');
    }

    public function logout()
    {
        Auth::logout();
        return redirect()->route('login.form');
    }
}
