<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>🎧 Audios</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <style>
        body {
            background: #f4f4f4;
            font-family: Arial, sans-serif;
        }
        .audio-container {
            max-width: 450px;
            margin: 50px auto;
            background: white;
            padding: 10px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }
        .audio-title {
            font-size: 20px;
            font-weight: bold;
            color: #2c3e50;
        }
        audio {
            width: 100%;
            margin-top: 10px;
        }
    </style>
</head>
<body>

<div class="audio-container text-center">
    <h2 class="mb-4">🎧 Audios de Capacitación</h2>
    @foreach($audios as $index => $audio)
        <div class="mb-3">
            <p class="audio-title">🔊 Audio {{ $index + 1 }}</p>
            <audio controls>
                <source src="{{ asset('audios/' . $audio) }}" type="audio/mpeg">
                Tu navegador no soporta el audio.
            </audio>
        </div>
    @endforeach
</div>

</body>
</html>
