<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Capacitación</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <style>
        /* Navbar estilizada */
        .navbar {
            background: linear-gradient(135deg, #2c3e50, #1c2833);
            padding: 12px 0;
        }

        .nav-link {
            color: #fff !important;
            font-weight: 500;
            transition: color 0.3s, transform 0.2s;
        }

        .nav-link:hover {
            color: #17a2b8 !important;
            transform: scale(1.05);
        }

        /* Imagen de usuario */
        .user-img {
            width: 35px;
            height: 35px;
            border-radius: 50%;
            border: 2px solid #17a2b8;
        }

        /* Dropdown */
        .dropdown-menu {
            border-radius: 10px;
            box-shadow: 0px 6px 10px rgba(0, 0, 0, 0.15);
        }

        .dropdown-item:hover {
            background: #17a2b8;
            color: #fff;
        }

        /* Contenedor del iframe */
        #content-frame {
            width: 100%;
            height: 80vh;
            border: none;
            display: block;
        }
    </style>
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark">
    <div class="container">
        
        <!-- Título "Capacitación" a la izquierda -->
        <a class="navbar-brand fw-bold" href="#">📚 Capacitación</a>

        <!-- Menú hamburguesa -->
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav"
            aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>

        <!-- Menú centrado -->
        <div class="collapse navbar-collapse justify-content-center" id="navbarNav">
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e('tests'); ?>" target="contentFrame">📝 Tarifario</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('pdfs')); ?>" target="contentFrame">📄 PDFs</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('audiose')); ?>" target="contentFrame">🎧 Audios</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('asistencia')); ?>" target="contentFrame">📌 Asistencia</a>
                </li>
            </ul>
        </div>

        <!-- Usuario a la derecha -->
        <ul class="navbar-nav ms-auto">
            <?php if(Auth::check()): ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle d-flex align-items-center" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <img src="https://cdn-icons-png.flaticon.com/512/3135/3135715.png" class="user-img me-2" alt="User">
                        <span>Hi, <?php echo e(Auth::user()->dni); ?></span>
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="userDropdown">
                        <li>
                            <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                               onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                🚪 Cerrar sesión
                            </a>
                            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                <?php echo csrf_field(); ?>
                            </form>
                        </li>
                    </ul>
                </li>
            <?php endif; ?>
        </ul>
        
    </div>
</nav>

<!-- Contenedor del iframe -->
<iframe id="content-frame" name="contentFrame"></iframe>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\capacitacion\resources\views/dash.blade.php ENDPATH**/ ?>